local t = Def.ActorFrame {};
	

	
t[#t+1] = Def.ActorFrame {
	LoadFont("_pixellari 32px") .. { -- Difficulty name
		  InitCommand=cmd(horizalign,center;zoom,0.8;y,-5;x,85;strokecolor,color("#000000");maxwidth,140;);
		  OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0;);
		  CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";); 
		  CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
		  PlayerJoinedMessageCommand=cmd(queuecommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
		  ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set");
		  TransitionCommand=cmd(finishtweening;smooth,0.2;diffusealpha,1;);
		  SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				self:finishtweening():smooth(0.3):diffusealpha(1)
				if stepsP1 ~= nil then
					local st = stepsP1:GetStepsType();
					local diff = stepsP1:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
						if stepsP1:IsAnEdit() then
							if stepsP1:GetChartName() ~= "" then
								self:settext(string.upper(stepsP1:GetChartName()));
							else
								self:settext("CUSTOM");
							end;
						else
							self:settext(string.upper(THEME:GetString("CustomDifficulty",ToEnumShortString(diff))));
						end;
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
				end
			else
				self:finishtweening():smooth(0.3):diffusealpha(0)
			end
		  end
	};
};
	t[#t+1] = LoadActor("_lifts") .. {
		InitCommand=cmd(horizalign,center;zoom,0.3;addx,-30;addy,-6);
		OnCommand=cmd(diffusealpha,0;queuecommand,"Set");
		CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
		SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP1 ~= nil then
						local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
						local P1Lifts = Getp1Radar:GetValue('RadarCategory_Lifts');
						if P1Lifts ~= 0 then
							self:smooth(0.3):diffusealpha(1)
						else
							self:smooth(0.3):diffusealpha(0)
						end;
					else
						self:smooth(0.3):diffusealpha(0)
					end
				else
					self:smooth(0.3):diffusealpha(0)
				end
			 end
	};
	t[#t+1] = LoadActor("_hands") .. {
		InitCommand=cmd(horizalign,center;zoom,0.3;addx,-30;addy,66);
		OnCommand=cmd(diffusealpha,0;queuecommand,"Set");
		CurrentSongChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
		CurrentStepsP1ChangedMessageCommand=cmd(finishtweening;queuecommand,"Set";);
		SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
				if song then 
					if stepsP1 ~= nil then
						local Getp1Radar = GAMESTATE:GetCurrentSteps(PLAYER_1):GetRadarValues(PLAYER_1);
						local P1Hands = Getp1Radar:GetValue('RadarCategory_Hands');
						if P1Hands ~= 0 then
							self:smooth(0.3):diffusealpha(1)
						else
							self:smooth(0.3):diffusealpha(0)
						end;
					else
						self:visible(false)
					end
				else
					self:visible(false)
				end
			 end
	};
t[#t+1] = Def.ActorFrame {	
	Def.Sprite{ -- FC badge
			InitCommand=cmd(y,145;x,84;zoom,0.2;diffusealpha,1;);
			OnCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			PlayerJoinedMessageCommand=cmd(playcommand,"Set");
			ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
			ShowCommand=function(self) self:finishtweening():smooth(0.2):diffusealpha(1) end;
			HideCommand=function(self) self:finishtweening():smooth(0.2):diffusealpha(0) end;
			SetCommand=function(self)
				local steps = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
				local comboType = ThemePrefs.Get("GreatContinuesCombo")
				local goodfc = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):FullComboOfScore('TapNoteScore_W4');
				local goods = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetTapNoteScores('TapNoteScore_W4');
				if song then
					if steps ~= nil then
						local score = PROFILEMAN:GetProfile(PLAYER_1):GetHighScoreList(song,steps):GetHighScores()
						local getscore = score[1]
						if getscore then
							showbadge = getscore:GetStageAward()
							if showbadge == "StageAward_FullComboW1" then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_altbw1badge.png")
							elseif showbadge == "StageAward_FullComboW2" then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bw2badge.png")
							elseif showbadge == "StageAward_SingleDigitW2" or showbadge == "StageAward_OneW2" then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bsdw2badge.png")
							elseif showbadge == "StageAward_FullComboW3" then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bw3badge.png")
							elseif showbadge == "StageAward_SingleDigitW3" or showbadge == "StageAward_OneW3" then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bsdw3badge.png")
							elseif showbadge == nil and goodfc and goods < 10 then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bsdw4badge.png")
							elseif showbadge == nil and goodfc then
								showaward = THEME:GetPathB("", "ScreenEvaluation underlay/_bw4badge.png")
							else
								showaward = nil
							end
							if showaward ~= nil then
								self:Load(showaward)
								self:playcommand("Show")
							else
								self:playcommand("Hide")
							end
						else
							self:playcommand("Hide")
						end
					end
				else
					self:playcommand("Hide")
				end
			end
	};
	Def.Sprite{ --Grade
			InitCommand=cmd(y,145;x,84;zoom,0.4;);
			OnCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			PlayerJoinedMessageCommand=cmd(playcommand,"Set");
			ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
			ShowCommand=function(self) self:finishtweening():smooth(0.2):diffusealpha(1) end;
			HideCommand=function(self) self:finishtweening():smooth(0.2):diffusealpha(0) end;
			SetCommand=function(self)
				local steps = GAMESTATE:GetCurrentSteps(PLAYER_1)
				local song = GAMESTATE:GetCurrentSong();
				if song then
					if steps ~= nil then
						local score = PROFILEMAN:GetProfile(PLAYER_1):GetHighScoreList(song,steps):GetHighScores()
						local getscore = score[1]
						if getscore then
							showscore = getscore:GetGrade()
							if showscore then
								grade = showscore
							else
								grade = nil
							end
						else
							grade = nil
						end
						if grade ~= nil then
							self:Load(THEME:GetPathG("","GradeDisplay Grade " .. grade))
							self:playcommand("Show")
						else
							self:playcommand("Hide")
						end
					end
				else
					self:playcommand("Hide")
				end
			end;
	};
};
return t	